<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/utils.php';

function h($s){ return htmlspecialchars($s ?? '', ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
function is_admin(){
    return isset($_SESSION['user']) && isset($_SESSION['user']['login']) && in_array($_SESSION['user']['login'], ADMIN_LOGINS, true);
}

// Pagination settings
$records_per_page = 35;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$page = max(1, $page); // Ensure page is at least 1

// Calculate offset for SQL query
$offset = ($page - 1) * $records_per_page;
?>
<!DOCTYPE html>
<html lang="ru">
<head>
<meta charset="utf-8">
<title>Архив.ДуДу2</title>
<style>
/* Centered container styles */
.container-wrapper {
  display: flex;
  justify-content: center;
  align-items: flex-start;
  min-height: 100vh;
  padding: 20px;
  background-color: #f0f0f0;
  font-family: Verdana, Arial, sans-serif;
}

.main-container {
  width: 100%;
  max-width: 1200px;
  background-color: white;
  border: 1px solid #ccc;
  box-shadow: 0 0 10px rgba(0,0,0,0.1);
}

.header {
  background: linear-gradient(to bottom, #0099cc, #007790, #005a70);
  color: white;
  padding: 10px 15px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  border-bottom: 1px solid #ccc;
}

.header-title {
  font-size: 18px;
  font-weight: bold;
}

.user-info {
  font-size: 12px;
}

.user-info a {
  color: white;
  text-decoration: none;
}

.user-info a:hover {
  text-decoration: underline;
}

.content-wrapper {
  display: flex;
  padding: 0;
}

.sidebar {
  width: 220px;
  background-color: #f5f5f5;
  border-right: 1px solid #ddd;
  padding: 15px;
}

.sidebar-section {
  margin-bottom: 20px;
}

.sidebar-title {
  background: linear-gradient(to bottom, #0099cc, #007790, #005a70);
  color: white;
  padding: 5px 8px;
  font-size: 12px;
  font-weight: bold;
  margin-bottom: 10px;
  border: 1px solid #005a70;
}

.sidebar-link {
  display: block;
  color: #0000cc;
  text-decoration: none;
  font-size: 12px;
  margin-bottom: 5px;
  padding: 2px 0;
}

.sidebar-link:hover {
  text-decoration: underline;
}

.search-form input[type="text"] {
  width: 100%;
  padding: 3px;
  font-size: 12px;
  margin-bottom: 5px;
  border: 1px solid #999;
}

.search-form input[type="submit"] {
  font-size: 12px;
  padding: 2px 8px;
  background-color: #007790;
  color: white;
  border: 1px solid #005a70;
  cursor: pointer;
}

.search-form input[type="submit"]:hover {
  background-color: #005a70;
}

.categories-list {
  font-size: 12px;
}

.categories-list a {
  color: #0000cc;
  text-decoration: none;
}

.categories-list a:hover {
  text-decoration: underline;
}

.main-content {
  flex: 1;
  padding: 15px;
}

/* Table styling */
.content-table {
  width: 100%;
  border-collapse: collapse;
}

.content-table th {
  background: linear-gradient(to bottom, #0099cc, #007790, #005a70);
  color: white;
  padding: 6px;
  text-align: left;
  font-weight: bold;
  font-size: 12px;
  font-family: Verdana;
}

.content-table td {
  padding: 6px;
  border-bottom: 1px solid #eee;
  font-size: 12px;
  font-family: Verdana;
}

.content-table tr:hover {
  background-color: #f0f0f0;
}

/* Category list styling */
.category-list {
  width: 100%;
  border-collapse: collapse;
}

.category-list td {
  padding: 6px;
  border-bottom: 1px solid #eee;
  font-size: 12px;
  font-family: Verdana;
}

.category-list tr:hover {
  background-color: #f0f0f0;
}

/* Pagination styling */
.pagination {
  display: flex;
  justify-content: center;
  margin: 20px 0;
  gap: 5px;
}

.pagination a, .pagination span {
  padding: 6px 12px;
  text-decoration: none;
  border: 1px solid #ddd;
  color: #0000cc;
  font-size: 12px;
}

.pagination a:hover {
  background-color: #f0f0f0;
}

.pagination .current {
  background-color: #0099cc;
  color: white;
  border: 1px solid #0099cc;
}

.footer {
  background-color: #f0f0f0;
  padding: 10px 15px;
  text-align: right;
  border-top: 1px solid #ddd;
  font-size: 11px;
  color: #666;
}


</style>

</head>
<body>
<div class="container-wrapper">
  <div class="main-container">
    <div class="header">
      <div class="header-title">Архив.ДуДу2</div>
      <div class="user-info">
        <?php if(isset($_SESSION['user'])): ?>
          Пользователь: <b><?php echo h($_SESSION['user']['name'] ?? $_SESSION['user']['login']); ?></b> |
          <?php if(is_admin()): ?><a href="admin.php">Админ панель</a> |<?php endif; ?>
          <a href="index.php?action=logout">Выход</a>
        <?php else: ?>
          <a href="<?php echo h(AUTH_LOGIN_URL . '&redirect_uri=' . urlencode(SITE_URL)); ?>">Войти</a>
        <?php endif; ?>
      </div>
    </div>

    <div class="content-wrapper">
      <div class="sidebar">
        <div class="sidebar-section">
          <div class="sidebar-title">Навигация</div>
          <a href="index.php" class="sidebar-link">Последние записи</a>
          <a href="browse.php" class="sidebar-link">Все категории</a>
          <?php if(is_admin()): ?><a href="admin.php" class="sidebar-link">Админ панель</a><?php endif; ?>
        </div>
        
        <div class="sidebar-section">
          <div class="sidebar-title">Поиск</div>
          <form action="search.php" method="get" class="search-form">
            <div style="display: flex;">
              <input type="text" name="q" size="15" style="flex: 1; margin-right: 5px;">
              <input type="submit" value="Найти" style="flex: 0 0 auto; padding: 3px 8px;">
            </div>
          </form>
        </div>
        
        <div class="sidebar-section">
          <div class="sidebar-title">Категории</div>
          <div class="categories-list">
            <?php
            $cat = isset($_GET['cat']) ? trim($_GET['cat']) : '';
            echo generateCategoryNav($db, $cat);
            ?>
          </div>
        </div>
      </div>
      
      <div class="main-content">
<?php
$cat = isset($_GET['cat']) ? trim($_GET['cat']) : '';
if($cat !== ''){
    $st = $db->prepare("SELECT id, name FROM categories WHERE slug=?");
    $st->execute([$cat]);
    $c = $st->fetch();
    if($c){
        echo '<font face=Verdana size=+0><b>Категория: '.h($c['name']).'</b></font><br><br>';
        
        // Get total number of posts for pagination
        $total_stmt = $db->prepare("SELECT COUNT(*) as total FROM posts WHERE category_id=?");
        $total_stmt->execute([$c['id']]);
        $total_records = $total_stmt->fetch()['total'];
        $total_pages = ceil($total_records / $records_per_page);
        
        // Use prepared statement with limit and offset for pagination
        $st2 = $db->prepare("SELECT id, title, slug, created_at FROM posts WHERE category_id=? ORDER BY created_at DESC LIMIT ? OFFSET ?");
        $st2->bindValue(1, $c['id'], PDO::PARAM_INT);
        $st2->bindValue(2, $records_per_page, PDO::PARAM_INT);
        $st2->bindValue(3, $offset, PDO::PARAM_INT);
        $st2->execute();
        $items = $st2->fetchAll();
        
        echo '<table class="content-table">';
        echo '<tr><th>Заголовок</th><th>Дата</th></tr>';
        foreach($items as $it){
            echo '<tr><td><a href="post.php?slug='.h($it['slug']).'">'.h($it['title']).'</a></td>';
            echo '<td>'.h($it['created_at']).'</td></tr>';
        }
        echo '</table>';
        
        // Display pagination links
        if ($total_pages > 1) {
            echo '<div class="pagination">';
            
            // Previous page link
            if ($page > 1) {
                echo '<a href="?cat='.h($cat).'&page='.($page-1).'">&laquo; Назад</a>';
            }
            
            // Page links
            for ($i = 1; $i <= $total_pages; $i++) {
                if ($i == $page) {
                    echo '<span class="current">'.$i.'</span>';
                } else {
                    echo '<a href="?cat='.h($cat).'&page='.$i.'">'.$i.'</a>';
                }
            }
            
            // Next page link
            if ($page < $total_pages) {
                echo '<a href="?cat='.h($cat).'&page='.($page+1).'">Вперед &raquo;</a>';
            }
            
            echo '</div>';
        }
    } else {
        echo '<font face=Verdana size=-1>Категория не найдена.</font>';
    }
} else {
    echo '<font face=Verdana size=+0><b>Все категории</b></font><br><br>';
    // Sort categories with English first, then Russian alphabetically
    $cats = $db->query("SELECT name, slug FROM categories")->fetchAll();
    usort($cats, function($a, $b) {
        // Check if names start with English letters
        $a_is_english = preg_match('/^[A-Za-z]/', $a['name']);
        $b_is_english = preg_match('/^[A-Za-z]/', $b['name']);
        
        // If one is English and the other is not, English comes first
        if ($a_is_english && !$b_is_english) return -1;
        if (!$a_is_english && $b_is_english) return 1;
        
        // If both are English or both are Russian, sort alphabetically
        return strcasecmp($a['name'], $b['name']);
    });
    
    echo '<table class="category-list">';
    $i=0;
    foreach($cats as $c){
        if(($i++ % 2)==0) echo '<tr>';
        echo '<td width=50%><a href="browse.php?cat='.h($c['slug']).'">'.h($c['name']).'</a></td>';
        if(($i % 2)==0) echo '</tr>';
    }
    if(($i % 2)!=0) echo '</tr>';
    echo '</table>';
}


?>
      </div>
    </div>
    
    <div class="footer">
      © <?php echo date('Y'); ?> Архив.ДуДу2
    </div>
  </div>
</div>
</body>
</html>